/*
 * Decompiled with CFR 0.152.
 */
package uk101.view.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import javax.swing.JPanel;
import uk101.hardware.ROM;
import uk101.hardware.Video;

public class VideoScreen
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final Color SCREEN_BLACK = Color.BLACK;
    public static final Color SCREEN_WHITE = Color.WHITE;
    public static final Color SCREEN_GREEN = Color.GREEN;
    public static final Color SCREEN_AMBER = Color.ORANGE;
    private int rows;
    private int cols;
    private Image[] charset;
    private byte[][] cells;
    private int cw;
    private int ch;
    private int sw;
    private int sh;
    private boolean syncPaint;

    public VideoScreen(Video video, int rows, int cols, int hscan, int vscan, int scale, Color colour) {
        this.setOpaque(true);
        this.setBackground(SCREEN_BLACK);
        this.rows = rows;
        this.cols = cols;
        this.cw = video.charWidth;
        this.ch = video.charHeight;
        this.sw = this.cw * hscan * scale;
        this.sh = this.ch * vscan * scale;
        this.cells = new byte[rows][];
        int i = 0;
        while (i < rows) {
            this.cells[i] = new byte[cols];
            Arrays.fill(this.cells[i], (byte)32);
            ++i;
        }
        Dimension size = new Dimension(cols * this.sw, rows * this.sh);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.makeCharacterSet(video.charSet, colour);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int minRow = 0;
        int minCol = 0;
        int maxRow = this.rows - 1;
        int maxCol = this.cols - 1;
        Rectangle clip = g.getClipBounds();
        if (clip != null) {
            minRow = clip.y / this.sh;
            maxRow = Math.min((clip.y + clip.height) / this.sh, maxRow);
            minCol = clip.x / this.sw;
            maxCol = Math.min((clip.x + clip.width) / this.sw, maxCol);
        }
        VideoScreen videoScreen = this;
        synchronized (videoScreen) {
            int y = minRow * this.sh;
            int r = minRow;
            while (r <= maxRow) {
                int x = minCol * this.sw;
                byte[] rcells = this.cells[r];
                int c = minCol;
                while (c <= maxCol) {
                    g.drawImage(this.charset[rcells[c] & 0xFF], x, y, this);
                    x += this.sw;
                    ++c;
                }
                y += this.sh;
                ++r;
            }
        }
    }

    public void setUpdateMode(boolean sync) {
        this.syncPaint = sync;
    }

    public synchronized void screenUpdate(int row, int col, byte b) {
        if (this.cells[row][col] != b) {
            this.cells[row][col] = b;
            if (this.syncPaint) {
                Graphics g = this.getGraphics();
                if (g != null) {
                    g.drawImage(this.charset[b & 0xFF], col * this.sw, row * this.sh, this);
                    g.dispose();
                } else {
                    this.repaint(col * this.sw, row * this.sh, this.sw, this.sh);
                }
            } else {
                this.repaint(col * this.sw, row * this.sh, this.sw, this.sh);
            }
        }
    }

    public Dimension getCellSize() {
        return new Dimension(this.sw, this.sh);
    }

    private void makeCharacterSet(ROM chargen, Color colour) {
        byte[] charmap = new byte[256 * this.cw * this.ch];
        int b = 0;
        int i = 0;
        while (i < 256 * this.ch) {
            byte pixels = chargen.readByte(i);
            int j = 7;
            while (j >= 0) {
                charmap[b++] = (byte)(pixels >> j & 1);
                --j;
            }
            ++i;
        }
        byte[] byArray = new byte[2];
        byArray[1] = (byte)colour.getRed();
        byte[] r = byArray;
        byte[] byArray2 = new byte[2];
        byArray2[1] = (byte)colour.getGreen();
        byte[] g = byArray2;
        byte[] byArray3 = new byte[2];
        byArray3[1] = (byte)colour.getBlue();
        byte[] b2 = byArray3;
        IndexColorModel colours = new IndexColorModel(1, 2, r, g, b2);
        this.charset = new Image[256];
        int offset = 0;
        int c = 0;
        while (c < 256) {
            Image img = this.createImage(new MemoryImageSource(this.cw, this.ch, (ColorModel)colours, charmap, offset, this.cw));
            offset += this.cw * this.ch;
            this.charset[c] = new BufferedImage(this.sw, this.sh, 1);
            Graphics gc = this.charset[c].getGraphics();
            gc.drawImage(img, 0, 0, this.sw, this.sh, null);
            gc.dispose();
            ++c;
        }
    }
}

